.H 1 "Processor Dependencies"
This section describes the processor dependencies such as register names.
There is a separate section for each processor.
.H 2 "SPARC"
The SPARC architecture is used in Sun's SPARCstations and Sun4 family of
workstations.
The chip is supported in SPARC pi and rtpi's Remote Unix Pi window. 
The registers are named:
.DS I F
$g0-$g7, $o0-$o5, $sp, $o7, $l0-$l7,
$i0-$i5, $fp, $i7, $psr, $pc, $npc, and $y.
.DE
.P
The values of
$o0-$o5, $sp, $o7, $l0-$l7, $i0-$i5, $fp, and $i7
are extracted from their saved locations on the stack and vary
in different Frame windows.
The other registers display the same value in all Frame windows.
The value of $g0 is always 0.
.H 2 "MIPS R3000"
The MIPS Computer Systems R3000 and R4000 processors are used in Silicon
Graphics (SGI) workstations.
The processor is supported in SGI pi and rtpi's Remote Unix Pi window. 
The register names use the MIPS software conventions:
.DS I F
$zero, $at, $v0, $v1, $a0-$a3, $t0-$t7, $s0-$s7, $t8, $t9, $k0, $k1,
$gp, $sp, $s8, $ra, $pc, $cause, $badvaddr, $mmhi, $mmlo, $fpcpcsr, and $fpceir.
.DE
.P
The values of
$s0-$s7 and $ra
are extracted from their saved locations on the stack and vary
in different Frame windows.
The other registers display the same value in all Frame windows.
The value of $zero is always 0.
.H 2 "MC680X0"
Members of the Motorola MC680X0 family of processors are supported
in Sun-3 pi and in rtpi with rtmon, NRTX, and the remote
Unix Pi window.
The registers are named:
.DS I F
$d0-$d7, $a0-$a5, $fp, $sp, $ps and $pc.
.DE
.P
The values of
$d2-$d7 and $a2-$a5
are extracted from their saved locations on the stack and vary
in different Frame windows.
The other registers display the same value in all Frame windows.
.P
If an rtpi target is running the debug monitor rtmon,
additional registers are available:
.DS I N
68000	$usp,$isp
68010	$usp,$isp,$vbr,$sfc,$dfc
68020	$usp,$isp,$vbr,$sfc,$dfc,$msp,$cacr,$caar
.DE
.P
With rtmon targets the value of $sp is either $usp, $isp, or $msp,
depending on the states of the Supervisor/User and Master/Interrupt bits
in $ps.
.H 2 "80386"
The PC version of pi and rtpi's Remote Unix Pi window
support 80[34]86 based personal computers running Unix SysV R3.2.[23].
The registers are named:
.DS I F
$eax, $ecx, $edx, $ebx, $esp, $ebp, $esi, $edi, $eip, $eflags, $ds,
$es, $fs, $gs, $ss, $cs, $trapno, $error, and $kesp.
.DE
.P
The values of
$ebx, $esi, and $edi
are extracted from their saved locations on the stack and vary
in different Frame windows.
The other registers display the same value in all Frame windows.
.H 2 "AT&T WE32100"
Rtpi supports AT&T WE32100 targets running the debug monitor.
The registers are named:
.DS I F
$r0-$r8, $fp, $ap, $psw, $sp, $pc, $pcbp, and $isp.
.DE
.P
The values of
$r3-$r8
are extracted from their saved locations on the stack and vary
in different Frame windows.
The others display the same value in all Frame windows.
.H 2 "DSP32C"
Rtpi supports the AT&T WEDSP32C targets running the debug monitor and
the chip simulator.
The registers are named:
.DS I F
$r0-$r12, $fp, $sp, $r15-$r19, $pin, $pout, 
$ivtp, $a0-$a3, $pc, $pcsh, $dauc, $ioc, $pcw, $npc, and $ticks.
.DE
.P
The values of
$r5-$r12
are extracted from their saved locations on the stack and vary
in different Frame windows.
The others display the same value in all Frame windows.
The value of $r0 is always 0.
.P
$pcsh, $npc and $ticks are only accessible with the simulator and contain
the DSP32C's shadow register, a pointer to the next instruction,
and the number of clock ticks since the program was started.
To time a block of code in the simulator with $ticks:
.AL 1
.LI
Set a breakpoint at the beginning of the block in a Source Text
or Assembler window.
.LI
Run the program in the simulator until the breakpoint is hit.
.LI
Clear the breakpoint.
.LI
Set $ticks to 0 from a Frame or the Globals window.
.LI
Set a breakpoint at the end of the code block.
.LI
Run the processor until it hits the breakpoint.
.LI
Read the value of $ticks.
.LE
.P
Since the DSP323C hardware does not provide special instructions or hardware
for breakponts or single stepping, the software implementation of breakpoints
and stepping has some limitations.
.H 3 "DSP32C Breakpoints"
On DSP hardware, breakpoints are implemented by replacing the
original instructions with a call to a breakpoint handler followed by a nop.
Breakpoints have the following restrictions (they don't apply to the simulator):
.AL 1
.LI
Breakpoints cannot be placed in consecutive locations.
.LI
Breakpoints cannot start on a delayed branch instruction.
.LI
Breakpoints cannot be placed in code that explicitly depends on
the pipeline latencies.
.LI
Breakpoints cannot be used in code that changes the value of r19.
The C compiler normally reserves this as an increment register.
.LI
Breakpoints cannot be placed between an instruction that sets the
processor's DAU or CAU flags and a conditional instruction that
depends on the flag values.
.LE
.H 2 "DSP32C Stepping"
The DSP32C is stepped by forcing the processor
into an interrupt handler and returning from the interrupt handler
while the interrupt line is held asserted.
This causes the DSP to execute one instruction, or if the instruction blocks
interrupts, several instructions.
While it is possible to step through any assembly code, multiple instructions
may be executed per step.
.P
Interactions between interrupts and the pipeline causes some different
register values to be seen when stepping in the simulator and on hardware.
In the simulator, the pc points to the instruction about to enter the pipeline.
The pipeline is suspended and the instruction results may not be
visible until several cycles later.
On hardware, the pipeline state is saved in invisible shadow registers and
the instructions in the pipeline keep on executing.
If you look at a register, you see the results of the instruction
directly before the pc.
However, instructions that follow may use a previous value retrieved from
the shadow registers when the program is continued.
.P
When the DSP32C is stepped the accumulators and pc are restored
from the shadow registers, so they cannot be modified.
After hitting a breakpoint, stepping the DSP32C steps two instructions so
the pc points to the first instruction after the breakpoint sequence.
